package com.androidbook.simplelivefolder;

import java.util.HashMap;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.provider.LiveFolders;
import android.text.TextUtils;

public class SimpleFieldnotesContentProvider extends ContentProvider {
    // kolumny
    public static final String _ID = "_id";
    public static final String FIELDNOTES_TITLE = "fieldnotes_title";
    public static final String FIELDNOTES_BODY = "fieldnotes_body";
    // dane
    public static final String AUTHORITY =
        "com.androidbook.simplelivefolder.SimpleFieldnotesContentProvider";
    // typy mime treści
    public static final String BASE_DATA_NAME = "fieldnotes";
    public static final String CONTENT_ITEM_TYPE =
        ContentResolver.CURSOR_ITEM_BASE_TYPE + "/vnd.androidbook.live."
            + BASE_DATA_NAME;
    public static final String CONTENT_TYPE =
        ContentResolver.CURSOR_DIR_BASE_TYPE + "/vnd.androidbook.live."
            + BASE_DATA_NAME;
    // identyfikatory URI
    public static final Uri CONTENT_URI =
        Uri.parse("content://" + AUTHORITY + "/"
            + BASE_DATA_NAME);
    public static final Uri LIVE_URI =
        Uri.parse("content://" + AUTHORITY + "/"
            + BASE_DATA_NAME + "/live");
    // dopasowywanie
    private static final int FIELDNOTES = 0x1000;
    private static final int FIELDNOTE_ITEM = 0x1001;
    private static final int FIELDNOTES_LIVE = 0x1100;
    private static final UriMatcher sURIMatcher =
        new UriMatcher(UriMatcher.NO_MATCH);
    static {
        sURIMatcher.addURI(AUTHORITY, BASE_DATA_NAME, FIELDNOTES);
        sURIMatcher.addURI(AUTHORITY, BASE_DATA_NAME + "/#", FIELDNOTE_ITEM);
        sURIMatcher.addURI(AUTHORITY, BASE_DATA_NAME + "/live", FIELDNOTES_LIVE);
    }
    // obsługa aktywnego folderu
    private static final HashMap<String, String> FIELDNOTES_LIVE_FOLDER_PROJECTION_MAP;
    static {
        FIELDNOTES_LIVE_FOLDER_PROJECTION_MAP = new HashMap<String, String>();
        FIELDNOTES_LIVE_FOLDER_PROJECTION_MAP.put(LiveFolders._ID, _ID + " AS "
            + LiveFolders._ID);
        FIELDNOTES_LIVE_FOLDER_PROJECTION_MAP.put(LiveFolders.NAME,
            FIELDNOTES_TITLE
                + " AS " + LiveFolders.NAME);
    }
    // baza danych
    private SimpleFieldnotesDatabase database;

    @Override
    public int delete(Uri uri, String whereClause, String[] whereArgs) {
        int match = sURIMatcher.match(uri);
        SQLiteDatabase sql = database.getWritableDatabase();
        int rowsAffected = 0;
        switch (match) {
        case FIELDNOTES:
            rowsAffected =
                sql.delete(SimpleFieldnotesDatabase.FIELDNOTES_TABLE,
                    whereClause,
                    whereArgs);
            break;
        case FIELDNOTE_ITEM:
            String id = uri.getLastPathSegment();
            if (TextUtils.isEmpty(whereClause)) {
                rowsAffected =
                    sql.delete(SimpleFieldnotesDatabase.FIELDNOTES_TABLE, _ID
                        + "="
                        + id, null);
            } else {
                rowsAffected =
                    sql.delete(SimpleFieldnotesDatabase.FIELDNOTES_TABLE,
                        whereClause
                            + " and " + _ID + "=" + id, whereArgs);
            }
            break;
        default:
            throw new IllegalArgumentException("Invalid URI " + uri);
        }
        getContext().getContentResolver().notifyChange(uri, null);
        return rowsAffected;
    }

    @Override
    public String getType(Uri uri) {
        int matchType = sURIMatcher.match(uri);
        switch (matchType) {
        case FIELDNOTES:
            return CONTENT_TYPE;
        case FIELDNOTE_ITEM:
            return CONTENT_ITEM_TYPE;
        default:
            return null;
        }
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        Uri newUri = null;
        int match = sURIMatcher.match(uri);
        if (match == FIELDNOTES) {
            SQLiteDatabase sql = database.getWritableDatabase();
            long newId =
                sql.insert(SimpleFieldnotesDatabase.FIELDNOTES_TABLE, null,
                    values);
            if (newId > 0) {
                newUri = ContentUris.withAppendedId(uri, newId);
                getContext().getContentResolver().notifyChange(uri, null);
            }
        }
        return newUri;
    }

    @Override
    public boolean onCreate() {
        database = new SimpleFieldnotesDatabase(getContext());
        return true;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection,
        String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
        queryBuilder.setTables(SimpleFieldnotesDatabase.FIELDNOTES_TABLE);
        int match = sURIMatcher.match(uri);
        switch (match) {
        case FIELDNOTE_ITEM:
            String id = uri.getLastPathSegment();
            queryBuilder.appendWhere(_ID + "=" + id);
            break;
        case FIELDNOTES_LIVE:
            queryBuilder.setProjectionMap(FIELDNOTES_LIVE_FOLDER_PROJECTION_MAP);
            break;
        default:
            throw new IllegalArgumentException("Niewłaściwe URI: " + uri);
        }
        SQLiteDatabase sql = database.getReadableDatabase();
        Cursor cursor =
            queryBuilder.query(sql, projection, selection, selectionArgs, null,
                null, sortOrder);
        cursor.setNotificationUri(getContext().getContentResolver(), uri);
        return cursor;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection,
        String[] selectionArgs) {
        // nie pozwalamy na aktualizacje :)
        return 0;
    }

    private class SimpleFieldnotesDatabase extends SQLiteOpenHelper {
        private static final String FIELDNOTES_TABLE = "fieldnotes";
        private static final String FIELDNOTES_DB_NAME = "fieldnotes_db";
        private static final int SCHEMA_VERSION = 1;
        private static final String FIELDNOTES_SCHEMA =
            "CREATE TABLE " + FIELDNOTES_TABLE + "("
                + _ID + " integer primary key autoincrement, "
                + FIELDNOTES_TITLE + " text NOT NULL, "
                + FIELDNOTES_BODY + " text NOT NULL"
                + ");";
        private static final String UPGRADE_DB_SCHEMA =
            "DROP TABLE IF EXISTS " + FIELDNOTES_TABLE;

        public SimpleFieldnotesDatabase(Context context) {
            super(context, FIELDNOTES_DB_NAME, null, SCHEMA_VERSION);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            db.execSQL(FIELDNOTES_SCHEMA);
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL(UPGRADE_DB_SCHEMA);
            onCreate(db);
        }
    }
}
